import type React from "react"
import type { Metadata } from "next"
import { Geist, Geist_Mono } from "next/font/google"
import { Analytics } from "@vercel/analytics/next"
import "./globals.css"

import QueryProvider from "@/components/providers/query-provider"
import { AuthProvider } from "@/context/auth-context"

import { BranchProvider } from "@/context/branch-context"

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode
}>) {
  return (
    <html lang="en">
      <body className={`font-sans antialiased`}>
        <AuthProvider>
          <QueryProvider>
            <BranchProvider>
              {children}
            </BranchProvider>
          </QueryProvider>
        </AuthProvider>
        <Analytics />
      </body>
    </html>
  )
}
