"use client"

import { Calendar, Users, Image as ImageIcon, Scissors, MapPin, UserCircle } from "lucide-react"
import { cn } from "@/lib/utils"
import Link from "next/link"
import { usePathname } from "next/navigation"
import Image from "next/image"

interface SidebarProps {
    isOpen: boolean
    setIsOpen: (isOpen: boolean) => void
}

export function AdminSidebar({ isOpen, setIsOpen }: SidebarProps) {
    const pathname = usePathname()

    const menuItems = [
        { id: "appointments", label: "Appointments", icon: Calendar, href: "/admin/appointments" },
        { id: "customers", label: "Customers", icon: Users, href: "/admin/customers" },
        { id: "services", label: "Services", icon: Scissors, href: "/admin/services" },
        { id: "gallery", label: "Gallery", icon: ImageIcon, href: "/admin/gallery" },
        { id: "testimonials", label: "Testimonials`", icon: UserCircle, href: "/admin/testimonials" },
        { id: "branches", label: "Branches", icon: MapPin, href: "/admin/branches" },
    ]

    const isActive = (href: string) => {
        if (href === "/admin" && pathname === "/admin") return true
        if (href !== "/admin" && pathname.startsWith(href)) return true
        return false
    }

    return (
        <div
            className={cn(
                "fixed inset-y-0 left-0 z-50 w-64 bg-card border-r border-border transform transition-transform duration-200 ease-in-out lg:translate-x-0 lg:static lg:block",
                isOpen ? "translate-x-0" : "-translate-x-full"
            )}
        >
            <div className="h-20 flex items-center justify-center border-b border-border">
                <div className="relative w-60 h-40">
                    <Image
                        src="/Logo/New Project.png"
                        alt="United Nails"
                        fill
                        className="object-contain"
                        priority
                    />
                </div>
            </div>

            <div className="p-4 space-y-2">
                {menuItems.map((item) => (
                    <Link
                        key={item.id}
                        href={item.href}
                        onClick={() => setIsOpen(false)}
                        className={cn(
                            "w-full flex items-center gap-3 px-4 py-3 rounded-lg transition-colors",
                            isActive(item.href)
                                ? "bg-gold/10 text-gold border border-gold/20"
                                : "text-foreground hover:bg-secondary"
                        )}
                    >
                        <item.icon className="w-5 h-5" />
                        <span className="font-medium">{item.label}</span>
                    </Link>
                ))}
            </div>
        </div>
    )
}
