"use client"

import { Facebook, Instagram, Twitter } from "lucide-react"

export default function Footer() {
  const currentYear = new Date().getFullYear()

  return (
    <footer className="bg-primary text-primary-foreground py-16 px-4 sm:px-6 lg:px-8">
      <div className="max-w-7xl mx-auto">
        <div className="grid md:grid-cols-4 gap-8 mb-8">
          <div>
            <h3 className="text-xl font-bold mb-4">
              <span className="text-gold">UNITED</span> NAILS
            </h3>
            <p className="text-primary-foreground/80 text-sm">
              Premier nail art academy and salon for exceptional services.
            </p>
          </div>

          <div>
            <h4 className="font-bold mb-4">Quick Links</h4>
            <ul className="space-y-2 text-sm">
              <li>
                <a href="#services" className="hover:text-gold transition">
                  Services
                </a>
              </li>
              <li>
                <a href="#gallery" className="hover:text-gold transition">
                  Gallery
                </a>
              </li>
              <li>
                <a href="#about" className="hover:text-gold transition">
                  About
                </a>
              </li>
              <li>
                <a href="#contact" className="hover:text-gold transition">
                  Contact
                </a>
              </li>
            </ul>
          </div>

          <div>
            <h4 className="font-bold mb-4">Services</h4>
            <ul className="space-y-2 text-sm">
              <li>
                <a href="#" className="hover:text-gold transition">
                  Manicure
                </a>
              </li>
              <li>
                <a href="#" className="hover:text-gold transition">
                  Pedicure
                </a>
              </li>
              <li>
                <a href="#" className="hover:text-gold transition">
                  Academy
                </a>
              </li>
              <li>
                <a href="#" className="hover:text-gold transition">
                  Consulting
                </a>
              </li>
            </ul>
          </div>

          <div>
            <h4 className="font-bold mb-4">Follow Us</h4>
            <div className="flex gap-4">
              <a href="#" className="hover:text-gold transition">
                <Facebook size={20} />
              </a>
              <a
                href="https://www.instagram.com/united_nails_/?hl=en"
                target="_blank"
                rel="noopener noreferrer"
                className="hover:text-gold transition"
              >
                <Instagram size={20} />
              </a>

              <a href="#" className="hover:text-gold transition">
                <Twitter size={20} />
              </a>
            </div>
          </div>
        </div>

        <div className="border-t border-primary-foreground/20 pt-8">
          <p className="text-center text-sm text-primary-foreground/60">
            © {currentYear} United Nails Academy. All rights reserved.
          </p>
        </div>
      </div>
    </footer>
  )
}
