"use client"

import { motion } from "framer-motion"

const galleryItems = [
  {
    id: 1,
    title: "Elegant Gold Design",
    category: "Manicure",
    image: "/images/united-20nails-1.webp",
  },
  {
    id: 2,
    title: "Pedicure Station",
    category: "Pedicure",
    image: "/images/interiror.webp",
  },
  {
    id: 3,
    title: "Professional Setup",
    category: "Salon",
    image: "/images/interior-1.jpg",
  },
  {
    id: 4,
    title: "Modern Styling Station",
    category: "Studio",
    image: "/images/hudsagda.webp",
  },
]

export default function Gallery() {
  return (
    <section id="gallery" className="py-20 px-4 sm:px-6 lg:px-8">
      <div className="max-w-7xl mx-auto">
        <motion.div
          className="text-center space-y-4 mb-16"
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.8, ease: "easeOut" }}
        >
          <h2 className="text-4xl md:text-5xl font-bold text-foreground">Our Studio</h2>
          <p className="text-lg text-muted-foreground max-w-2xl mx-auto">
            Experience our luxurious and elegantly designed salon spaces
          </p>
        </motion.div>

        <div className="grid md:grid-cols-2 gap-6">
          {galleryItems.map((item, index) => (
            <motion.div
              key={item.id}
              className="relative h-80 rounded-xl overflow-hidden group cursor-pointer shadow-md"
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              viewport={{ margin: "-50px" }}
              transition={{ duration: 0.6, delay: index * 0.1, ease: "easeOut" }}
            >
              <img
                src={item.image || "/placeholder.svg"}
                alt={item.title}
                className="w-full h-full object-cover group-hover:scale-110 transition duration-500"
              />
              <div className="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition duration-300 flex flex-col justify-end p-6">
                <h3 className="text-white text-xl font-bold">{item.title}</h3>
                <p className="text-white/80 text-sm">{item.category}</p>
              </div>
            </motion.div>
          ))}
        </div>
      </div>
    </section>
  )
}
