"use server"

import axios from "axios"

type WhatsAppPayload = {
  branchPhone: string
  customerDetails: {
    name: string
    phone: string
    gender: string
  }
  appointmentDetails: {
    serviceName: string
    branchName: string
    date: string
    time: string
  }
}

export async function sendWhatsAppNotification(payload: WhatsAppPayload) {
  try {
    const apiKey = process.env.GUPSHUP_API_KEY
    const sourceNumber = process.env.GUPSHUP_PHONE_NUMBER

    if (!apiKey || !sourceNumber) {
      return { success: false, error: "WhatsApp not configured" }
    }

    const params = new URLSearchParams({
      channel: "whatsapp",
      source: sourceNumber.replace(/\D/g, ""),
      destination: payload.branchPhone.replace(/\D/g, ""),
      "src.name": "testingunitednails",
      message: JSON.stringify({
        type: "template",
        template: {
          name: "appointment_created",
          language: { code: "en" },
          components: [
            {
              type: "body",
              parameters: [
                { type: "text", text: payload.customerDetails.name },
                { type: "text", text: payload.appointmentDetails.serviceName },
                { type: "text", text: payload.appointmentDetails.date },
                { type: "text", text: payload.appointmentDetails.time },
                { type: "text", text: payload.appointmentDetails.branchName },
              ],
            },
          ],
        },
      }),
    })

    const response = await axios.post(
      "https://api.gupshup.io/wa/api/v1/msg",
      params.toString(),
      {
        headers: {
          apikey: apiKey,
          "Content-Type": "application/x-www-form-urlencoded",
        },
      }
    )

    return { success: true, data: response.data }
  } catch (error: any) {
    return {
      success: false,
      error: error.response?.data || error.message,
    }
  }
}
